/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.singletable;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.InMemoryCounterIdentifierGenerator;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.builder.BuildLifeCycleListener;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Engine;
import org.codefilarete.stalactite.engine.model.Truck;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EmptySubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.singletable.SingleTablePolymorphismPersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.PersistentFieldHarvester;
import org.codefilarete.stalactite.mapping.id.manager.BeforeInsertIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.function.Sequence;
import org.codefilarete.tool.trace.MutableLong;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.types.Type;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

class SingleTablePolymorphismPersisterTest {
    private SingleTablePolymorphismPersister<AbstractToto, Identifier<Integer>, ?, String> testInstance;
    private PreparedStatement preparedStatement;
    private ArgumentCaptor<Integer> valueCaptor;
    private ArgumentCaptor<Integer> indexCaptor;
    private ArgumentCaptor<String> statementArgCaptor;
    private InMemoryCounterIdentifierGenerator identifierGenerator;
    private DefaultEntityMapping<AbstractToto, Identifier<Integer>, ?> totoEntityMapping;
    private DefaultDialect dialect;
    private final EffectiveBatchedRowCount effectiveBatchedRowCount = new EffectiveBatchedRowCount();
    private final Hanger.Holder<Long> expectedRowCountForUpdate = new Hanger.Holder();
    private Connection connection;

    SingleTablePolymorphismPersisterTest() {
    }

    protected ConfiguredRelationalPersister<TotoA, Identifier<Integer>> initMappingTotoA(Table totoTable) {
        PersistentFieldHarvester persistentFieldHarvester = new PersistentFieldHarvester();
        Map mappedFields = persistentFieldHarvester.mapFields(TotoA.class, totoTable);
        PropertyAccessor primaryKeyAccessor = Accessors.propertyAccessor((Field)persistentFieldHarvester.getField("id"));
        persistentFieldHarvester.getColumn(primaryKeyAccessor).primaryKey();
        IdentifierInsertionManager identifierManager = this.totoEntityMapping.getIdMapping().getIdentifierInsertionManager();
        return new SimpleRelationalEntityPersister(new DefaultEntityMapping(TotoA.class, totoTable, mappedFields, (ReversibleAccessor)primaryKeyAccessor, identifierManager), (Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> this.connection, 3));
    }

    protected ConfiguredRelationalPersister<TotoB, Identifier<Integer>> initMappingTotoB(Table totoTable) {
        PersistentFieldHarvester persistentFieldHarvester = new PersistentFieldHarvester();
        Map mappedFields = persistentFieldHarvester.mapFields(TotoB.class, totoTable);
        PropertyAccessor primaryKeyAccessor = Accessors.propertyAccessor((Field)persistentFieldHarvester.getField("id"));
        persistentFieldHarvester.getColumn(primaryKeyAccessor).primaryKey();
        IdentifierInsertionManager identifierManager = this.totoEntityMapping.getIdMapping().getIdentifierInsertionManager();
        return new SimpleRelationalEntityPersister(new DefaultEntityMapping(TotoB.class, totoTable, mappedFields, (ReversibleAccessor)primaryKeyAccessor, identifierManager), (Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> this.connection, 3));
    }

    protected void initMapping() {
        Field fieldId = Reflections.getField(AbstractToto.class, (String)"id");
        Field fieldA = Reflections.getField(AbstractToto.class, (String)"x");
        Field fieldQ = Reflections.getField(AbstractToto.class, (String)"q");
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", fieldId.getType()).primaryKey();
        Column xColumn = totoTable.addColumn("x", fieldA.getType());
        Column qColumn = totoTable.addColumn("q", fieldQ.getType());
        PropertyAccessor identifierAccessor = Accessors.propertyAccessor((Field)fieldId);
        Maps.ChainingHashMap totoPropertyMapping = Maps.forHashMap(PropertyAccessor.class, Column.class).add((Object)identifierAccessor, (Object)idColumn).add((Object)Accessors.propertyAccessor((Field)fieldA), (Object)xColumn).add((Object)Accessors.propertyAccessor((Field)fieldQ), (Object)qColumn);
        this.identifierGenerator = new InMemoryCounterIdentifierGenerator();
        BeforeInsertIdentifierManager beforeInsertIdentifierManager = new BeforeInsertIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor((ReversibleAccessor)identifierAccessor), () -> new PersistableIdentifier<Integer>(this.identifierGenerator.next()), Identifier.class);
        this.totoEntityMapping = new DefaultEntityMapping(AbstractToto.class, totoTable, (Map)totoPropertyMapping, (ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)beforeInsertIdentifierManager);
        JavaTypeToSqlTypeMapping simpleTypeMapping = new JavaTypeToSqlTypeMapping();
        simpleTypeMapping.put(Identifier.class, "int");
        this.dialect = new DefaultDialect(simpleTypeMapping);
        this.dialect.setInOperatorMaxSize(3);
        this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new ParameterBinder<Identifier>(){

            public Class<Identifier> getType() {
                return Identifier.class;
            }

            public Identifier doGet(ResultSet resultSet, String columnName) throws SQLException {
                return new PersistedIdentifier<Object>(resultSet.getObject(columnName));
            }

            public void set(PreparedStatement statement, int valueIndex, Identifier value) throws SQLException {
                statement.setInt(valueIndex, (Integer)value.getDelegate());
            }
        });
        this.dialect.getColumnBinderRegistry().register(Set.class, (ParameterBinder)new ParameterBinder<Set<Integer>>(){

            public void set(PreparedStatement preparedStatement, int valueIndex, Set<Integer> value) throws SQLException {
                if (value != null) {
                    preparedStatement.setArray(valueIndex, (Array)new JDBCArrayBasic((Object[])value.toArray(new Integer[0]), (Type)Type.SQL_INTEGER));
                } else {
                    preparedStatement.setArray(valueIndex, null);
                }
            }

            public Set<Integer> doGet(ResultSet resultSet, String columnName) throws SQLException {
                Array array = resultSet.getArray(columnName);
                return array == null ? null : new KeepOrderSet((Object[])((Integer[])array.getArray()));
            }

            public Class<Set<Integer>> getType() {
                return Set.class;
            }
        });
    }

    protected <T extends Table<T>> void initTest() throws SQLException {
        this.identifierGenerator.reset();
        this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.preparedStatement.executeLargeBatch()).thenAnswer(invocation -> this.effectiveBatchedRowCount.next());
        Mockito.when((Object)this.preparedStatement.executeLargeUpdate()).thenAnswer(invocation -> (Long)this.expectedRowCountForUpdate.get());
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.preparedStatement.getConnection()).thenReturn((Object)this.connection);
        this.statementArgCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture())).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture(), ArgumentMatchers.anyInt())).thenReturn((Object)this.preparedStatement);
        this.valueCaptor = ArgumentCaptor.forClass(Integer.class);
        this.indexCaptor = ArgumentCaptor.forClass(Integer.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)this.connection);
        SimpleRelationalEntityPersister mainPersister = new SimpleRelationalEntityPersister(this.totoEntityMapping, (Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> this.connection, 3));
        ConfiguredRelationalPersister<TotoA, Identifier<Integer>> totoAIdentifierConfiguredPersister = this.initMappingTotoA(mainPersister.getMainTable());
        ConfiguredRelationalPersister<TotoB, Identifier<Integer>> totoBIdentifierConfiguredPersister = this.initMappingTotoB(mainPersister.getMainTable());
        Maps.ChainingHashMap subclasses = Maps.forHashMap((Class)null, (Class)null).add(TotoA.class, totoAIdentifierConfiguredPersister).add(TotoB.class, totoBIdentifierConfiguredPersister);
        Column dtype = this.totoEntityMapping.getTargetTable().addColumn("DTYPE", Integer.class);
        PolymorphismPolicy.SingleTablePolymorphism polymorphismPolicy = new PolymorphismPolicy.SingleTablePolymorphism(dtype.getName(), dtype.getJavaType());
        polymorphismPolicy.addSubClass(new EmptySubEntityMappingConfiguration<TotoA>(TotoA.class), (Object)100);
        polymorphismPolicy.addSubClass(new EmptySubEntityMappingConfiguration<TotoB>(TotoB.class), (Object)200);
        this.testInstance = new SingleTablePolymorphismPersister((ConfiguredRelationalPersister)mainPersister, (Map)subclasses, new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider(dataSource), 3).getConnectionProvider(), (Dialect)this.dialect, dtype, polymorphismPolicy);
    }

    void assertCapturedPairsEqual(PairSetList<Integer, Integer> expectedPairs) {
        List obtainedPairs = PairSetList.toPairs((Iterable)this.indexCaptor.getAllValues(), (Iterable)this.valueCaptor.getAllValues());
        ArrayList obtained = new ArrayList();
        int startIndex = 0;
        for (Set expectedPair : expectedPairs.asList()) {
            obtained.add(new HashSet(obtainedPairs.subList(startIndex, startIndex += expectedPair.size())));
        }
        Assertions.assertThat(obtained).isEqualTo((Object)expectedPairs.asList());
    }

    static class TotoB
    extends AbstractToto {
        private Integer b;

        public TotoB() {
        }

        TotoB(int id, Integer x, Integer b) {
            super(id, x);
            this.b = b;
        }

        TotoB(Integer x, Integer b) {
            super(x);
            this.b = b;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)(this.id == null ? "null" : (Serializable)this.id.getDelegate())).add((Object)"x", (Object)this.x).add((Object)"b", (Object)this.b) + "]";
        }
    }

    static class TotoA
    extends AbstractToto {
        private Integer a;

        TotoA() {
        }

        TotoA(int id, Integer x, Integer a) {
            super(id, x);
            this.a = a;
        }

        TotoA(Integer x, Integer a) {
            super(x);
            this.a = a;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)(this.id == null ? "null" : (Serializable)this.id.getDelegate())).add((Object)"x", (Object)this.x).add((Object)"a", (Object)this.a) + "]";
        }
    }

    private static abstract class AbstractToto
    implements Identified<Integer> {
        protected Identifier<Integer> id;
        protected Integer x;
        private Set<Integer> q;

        public AbstractToto() {
        }

        public AbstractToto(int id, Integer x) {
            this.id = new PersistableIdentifier<Integer>(id);
            this.x = x;
        }

        public AbstractToto(Integer x) {
            this.x = x;
        }

        @Override
        public Identifier<Integer> getId() {
            return this.id;
        }

        public Integer getX() {
            return this.x;
        }

        public Set<Integer> getQ() {
            return this.q;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)(this.id == null ? "null" : (Serializable)this.id.getDelegate())).add((Object)"x", (Object)this.x) + "]";
        }
    }

    @Nested
    class OneToTablePerClass {
        private final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        private final PersistenceContext persistenceContext;

        OneToTablePerClass() {
            this.DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
            this.DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
            this.DIALECT.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
            this.DIALECT.getSqlTypeRegistry().put(Color.class, "int");
            this.persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), HSQLDBDialectBuilder.defaultHSQLDBDialect());
        }

        @Test
        void oneSubClass() {
            EntityPersister enginePersister = MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Engine::getVehicle, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor), (Object)"C"))).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Engine"});
            Assertions.assertThat((Collection)this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Engine.class});
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Engine dummyEngine = new Engine(42L);
            dummyEngine.setVehicle(dummyCar);
            enginePersister.insert((Object)dummyEngine);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = this.persistenceContext.newQuery((CharSequence)"select * from Vehicle", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            enginePersister.persist((Object)dummyEngine);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            Engine loadedEngine = (Engine)enginePersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedEngine).usingRecursiveComparison().isEqualTo((Object)dummyEngine);
            enginePersister.delete((Object)dummyEngine);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = this.persistenceContext.newQuery((CharSequence)"select id from Engine", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister enginePersister = MappingEase.entityBuilder(Engine.class, Identifier.LONG_TYPE).mapKey(Engine::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToOne(Engine::getVehicle, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel), (Object)"Car").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class), (Object)"Truck"))).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Engine"});
            Assertions.assertThat((Collection)this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Engine.class});
            DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Engine dummyEngine = new Engine(42L);
            dummyEngine.setVehicle(dummyCar);
            enginePersister.insert((Object)dummyEngine);
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = this.persistenceContext.newQuery((CharSequence)"select id from Vehicle", Integer.class).mapKey("id", Integer.class);
            Set vehicleIds = (Set)vehicleIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)vehicleIds).containsExactly((Object[])new Integer[]{1});
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            dummyEngine.setVehicle(dummyTruck);
            enginePersister.persist((Object)dummyEngine);
            vehicleIds = (Set)vehicleIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)vehicleIds).containsExactly((Object[])new Integer[]{2});
            Engine loadedVehicle = (Engine)enginePersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Object)loadedVehicle).usingRecursiveComparison().isEqualTo((Object)dummyEngine);
            enginePersister.delete((Object)loadedVehicle);
            PersistenceContext.ExecutableBeanPropertyQueryMapper engineQuery = this.persistenceContext.newQuery((CharSequence)"select id from Vehicle", Long.class).mapKey("id", Long.class);
            Assertions.assertThat((Collection)((Collection)engineQuery.execute(Accumulators.toSet()))).isEmpty();
        }
    }

    @Nested
    class LoadProjectionByEntityCriteria {
        LoadProjectionByEntityCriteria() {
        }

        @BeforeEach
        void setUp() throws SQLException {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
            SingleTablePolymorphismPersisterTest.this.initMapping();
            SingleTablePolymorphismPersisterTest.this.initTest();
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterBuild);
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterAllBuild);
        }

        @Test
        void selectProjectionWhere() throws SQLException {
            InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"count", (Object)42L)}));
            Mockito.when((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenAnswer(arg_0 -> LoadProjectionByEntityCriteria.lambda$selectProjectionWhere$0((ResultSet)resultSet, arg_0));
            EntityPersister.ExecutableProjectionQuery totoRelationalExecutableEntityQuery = SingleTablePolymorphismPersisterTest.this.testInstance.selectProjectionWhere(select -> select.add((Selectable)Operators.count((Selectable[])new Selectable[]{select.giveColumn(AbstractToto::getId)}), "count"), AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)77));
            long countValue = (Long)totoRelationalExecutableEntityQuery.execute((Accumulator)new Accumulator<ExecutableProjection.ProjectionDataProvider, MutableLong, Long>(){

                public Supplier<MutableLong> supplier() {
                    return MutableLong::new;
                }

                public BiConsumer<MutableLong, ExecutableProjection.ProjectionDataProvider> aggregator() {
                    return (modifiableInt, selectableObjectFunction) -> {
                        Long apply = (Long)selectableObjectFunction.getValue("count", Long.TYPE);
                        modifiableInt.reset(apply.longValue());
                    };
                }

                public Function<MutableLong, Long> finisher() {
                    return MutableLong::getValue;
                }
            });
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select count(Toto.id) as count from Toto where Toto.x = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)77);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Assertions.assertThat((long)countValue).isEqualTo(42L);
        }

        private static /* synthetic */ ResultSet lambda$selectProjectionWhere$0(ResultSet resultSet, InvocationOnMock invocation) throws Throwable {
            return resultSet;
        }
    }

    @Nested
    class CRUD {
        CRUD() {
        }

        @BeforeEach
        void setUp() throws SQLException {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
            SingleTablePolymorphismPersisterTest.this.initMapping();
            SingleTablePolymorphismPersisterTest.this.initTest();
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterBuild);
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(BuildLifeCycleListener::afterAllBuild);
        }

        @AfterEach
        void removeEntityCandidates() {
            PersisterBuilderContext.CURRENT.remove();
        }

        @Test
        void insert() throws SQLException {
            SingleTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L, 1L}, {1L, 1L}}));
            SingleTablePolymorphismPersisterTest.this.testInstance.insert((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA((Integer)17, (Integer)23), new TotoA((Integer)29, (Integer)31), new TotoB((Integer)37, (Integer)41), new TotoB((Integer)43, (Integer)53)}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)16))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"insert into Toto(a, id, x, q, DTYPE) values (?, ?, ?, ?, ?)", "insert into Toto(b, id, x, q, DTYPE) values (?, ?, ?, ?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)23).add((Object)2, (Object)1).add((Object)3, (Object)17).add((Object)5, (Object)100).newRow((Object)1, (Object)31).add((Object)2, (Object)2).add((Object)3, (Object)29).add((Object)5, (Object)100).newRow((Object)1, (Object)41).add((Object)2, (Object)3).add((Object)3, (Object)37).add((Object)5, (Object)200).newRow((Object)1, (Object)53).add((Object)2, (Object)4).add((Object)3, (Object)43).add((Object)5, (Object)200);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void update() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoDTYPEAlias = "Toto_DTYPE";
            Mockito.when((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)1).add((Object)totoDTYPEAlias, (Object)100).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null), Maps.asMap((Object)totoIdAlias, (Object)2).add((Object)totoDTYPEAlias, (Object)100).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null), Maps.asMap((Object)totoIdAlias, (Object)3).add((Object)totoDTYPEAlias, (Object)200).add((Object)totoXAlias, (Object)37).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)totoIdAlias, (Object)4).add((Object)totoDTYPEAlias, (Object)200).add((Object)totoXAlias, (Object)43).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53)})));
            SingleTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{2L}, {2L}}));
            SingleTablePolymorphismPersisterTest.this.testInstance.update((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 123), new TotoA(2, 29, 131), new TotoB(3, 37, 141), new TotoB(4, 43, 153)}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)16))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.a as Toto_a, Toto.b as Toto_b, Toto.DTYPE as " + totoDTYPEAlias + " from Toto where Toto.id in (?, ?, ?, ?)", "update Toto set a = ?, x = ?, q = ? where id = ?", "update Toto set b = ?, x = ?, q = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).add((Object)4, (Object)4).newRow((Object)1, (Object)123).add((Object)2, (Object)17).add((Object)4, (Object)1).newRow((Object)1, (Object)131).add((Object)2, (Object)29).add((Object)4, (Object)2).newRow((Object)1, (Object)141).add((Object)2, (Object)37).add((Object)4, (Object)3).newRow((Object)1, (Object)153).add((Object)2, (Object)43).add((Object)4, (Object)4);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void updateById() throws SQLException {
            SingleTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{2L}, {2L}}));
            SingleTablePolymorphismPersisterTest.this.testInstance.updateById((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 123), new TotoA(2, 29, 131), new TotoB(3, 37, 141), new TotoB(4, 43, 153)}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"update Toto set a = ?, x = ?, q = ? where id = ?", "update Toto set b = ?, x = ?, q = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)123).add((Object)2, (Object)17).add((Object)4, (Object)1).newRow((Object)1, (Object)131).add((Object)2, (Object)29).add((Object)4, (Object)2).newRow((Object)1, (Object)141).add((Object)2, (Object)37).add((Object)4, (Object)3).newRow((Object)1, (Object)153).add((Object)2, (Object)43).add((Object)4, (Object)4);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete() throws SQLException {
            SingleTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L}}));
            SingleTablePolymorphismPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new TotoA[]{new TotoA(7, 17, 23)}));
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete_multiple() throws SQLException {
            SingleTablePolymorphismPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{2L}, {2L}}));
            SingleTablePolymorphismPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)}));
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id = ?", "delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)1, (Object)2).add((Object)1, (Object)3).newRow((Object)1, (Object)4);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById() throws SQLException {
            SingleTablePolymorphismPersisterTest.this.expectedRowCountForUpdate.set((Object)1L);
            SingleTablePolymorphismPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new TotoA[]{new TotoA(7, 17, 23)}));
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById_multiple() throws SQLException {
            SingleTablePolymorphismPersisterTest.this.expectedRowCountForUpdate.set((Object)2L);
            SingleTablePolymorphismPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)}));
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id in (?, ?)", "delete from Toto where id in (?, ?)"}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).newRow((Object)1, (Object)3).add((Object)2, (Object)4);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void select() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoDTYPEAlias = "Toto_DTYPE";
            Mockito.when((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)1).add((Object)totoDTYPEAlias, (Object)100).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null), Maps.asMap((Object)totoIdAlias, (Object)2).add((Object)totoDTYPEAlias, (Object)100).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null), Maps.asMap((Object)totoIdAlias, (Object)3).add((Object)totoDTYPEAlias, (Object)200).add((Object)totoXAlias, (Object)37).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)totoIdAlias, (Object)4).add((Object)totoDTYPEAlias, (Object)200).add((Object)totoXAlias, (Object)43).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53)})));
            Set select = SingleTablePolymorphismPersisterTest.this.testInstance.select((Iterable)Arrays.asList((Object[])new Identifier[]{new PersistedIdentifier<Integer>(1), new PersistedIdentifier<Integer>(2), new PersistedIdentifier<Integer>(3), new PersistedIdentifier<Integer>(4)}));
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.a as Toto_a, Toto.b as Toto_b, Toto.DTYPE as " + totoDTYPEAlias + " from Toto where Toto.id in (?, ?, ?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).add((Object)4, (Object)4);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }

        @Test
        void selectWhere() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoDTYPEAlias = "Toto_DTYPE";
            Mockito.when((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null).add((Object)totoDTYPEAlias, (Object)100), Maps.asMap((Object)totoIdAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null).add((Object)totoDTYPEAlias, (Object)100), Maps.asMap((Object)totoIdAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41).add((Object)totoDTYPEAlias, (Object)200), Maps.asMap((Object)totoIdAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53).add((Object)totoDTYPEAlias, (Object)200)})));
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = SingleTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)42));
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.DTYPE as " + totoDTYPEAlias + " from Toto where Toto.x = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)42);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }

        @Test
        void selectWhere_orderByOnNonCollectionProperty_orderByIsAddedToSQL() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoDTYPEAlias = "Toto_DTYPE";
            Mockito.when((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)1).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null).add((Object)totoDTYPEAlias, (Object)100), Maps.asMap((Object)totoIdAlias, (Object)2).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null).add((Object)totoDTYPEAlias, (Object)100), Maps.asMap((Object)totoIdAlias, (Object)3).add((Object)totoXAlias, (Object)37).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41).add((Object)totoDTYPEAlias, (Object)200), Maps.asMap((Object)totoIdAlias, (Object)4).add((Object)totoXAlias, (Object)43).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53).add((Object)totoDTYPEAlias, (Object)200)})));
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = (RelationalEntityPersister.ExecutableEntityQueryCriteria)SingleTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)42)).orderBy(AbstractToto::getX);
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.DTYPE as " + totoDTYPEAlias + " from Toto where Toto.x = ? order by Toto.x asc"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)42);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }

        @Test
        void selectWhere_orderByOnCollectionProperty_throwsException() {
            Assertions.assertThatCode(() -> {
                RelationalEntityPersister.ExecutableEntityQueryCriteria cfr_ignored_0 = (RelationalEntityPersister.ExecutableEntityQueryCriteria)SingleTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getX, (ConditionalOperator)Operators.eq((Object)42)).orderBy(AbstractToto::getQ);
            }).hasMessage("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : o.c.s.e.r.s.SingleTablePolymorphismPersisterTest$AbstractToto::getQ");
        }

        @Test
        void selectWhere_collectionCriteria() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoXAlias = "Toto_x";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoDTYPEAlias = "Toto_DTYPE";
            Mockito.when((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)1).add((Object)"DISCRIMINATOR", (Object)100), Maps.asMap((Object)totoIdAlias, (Object)2).add((Object)"DISCRIMINATOR", (Object)100), Maps.asMap((Object)totoIdAlias, (Object)3).add((Object)"DISCRIMINATOR", (Object)200), Maps.asMap((Object)totoIdAlias, (Object)4).add((Object)"DISCRIMINATOR", (Object)200)})), (Object[])new ResultSet[]{new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)1).add((Object)totoDTYPEAlias, (Object)100).add((Object)totoXAlias, (Object)17).add((Object)totoAAlias, (Object)23).add((Object)totoBAlias, null), Maps.asMap((Object)totoIdAlias, (Object)2).add((Object)totoDTYPEAlias, (Object)100).add((Object)totoXAlias, (Object)29).add((Object)totoAAlias, (Object)31).add((Object)totoBAlias, null), Maps.asMap((Object)totoIdAlias, (Object)3).add((Object)totoDTYPEAlias, (Object)200).add((Object)totoXAlias, (Object)37).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)41), Maps.asMap((Object)totoIdAlias, (Object)4).add((Object)totoDTYPEAlias, (Object)200).add((Object)totoXAlias, (Object)43).add((Object)totoAAlias, null).add((Object)totoBAlias, (Object)53)}))});
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = SingleTablePolymorphismPersisterTest.this.testInstance.selectWhere(AbstractToto::getQ, (ConditionalOperator)Operators.eq((Object)Arrays.asHashSet((Object[])new Integer[]{42})));
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SingleTablePolymorphismPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SingleTablePolymorphismPersisterTest.this.indexCaptor.capture(), (Integer)SingleTablePolymorphismPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SingleTablePolymorphismPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.DTYPE as " + "DISCRIMINATOR" + " from Toto where Toto.q = ?", "select Toto.id as " + totoIdAlias + ", Toto.x as " + totoXAlias + ", Toto.q as Toto_q, Toto.a as Toto_a, Toto.b as Toto_b, Toto.DTYPE as " + totoDTYPEAlias + " from Toto where Toto.id in (?, ?, ?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1);
            SingleTablePolymorphismPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)select).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new AbstractToto[]{new TotoA(1, 17, 23), new TotoA(2, 29, 31), new TotoB(3, 37, 41), new TotoB(4, 43, 53)});
        }
    }

    private static class EffectiveBatchedRowCount
    implements Sequence<long[]> {
        private Iterator<long[]> rowCounts;

        private EffectiveBatchedRowCount() {
        }

        public void setRowCounts(List<long[]> rowCounts) {
            this.rowCounts = rowCounts.iterator();
        }

        public long[] next() {
            return this.rowCounts.next();
        }
    }
}

